import { Injectable } from '@angular/core';
import { NgRedux } from 'ng2-redux';
import { IAppState } from '../store';
import {
  TERMINOLOGIST_ROLE,
  RESEARCHER_ROLE,
} from '../constants';

@Injectable()
export class RoleServices {
  constructor(
    private ngRedux: NgRedux<IAppState>,
    ) {
  }

  getState() {
    return this.ngRedux.getState();
  }

  isTerminologist() {
    return this.ngRedux.getState().system.session.userRole === TERMINOLOGIST_ROLE;
  }

  isResearcher() {
    return this.ngRedux.getState().system.session.userRole === RESEARCHER_ROLE;
  }


}